/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef SPICE_H
#define SPICE_H

#include <QObject>
#include <QString>
#include <QStringList>
#include <QVector>
#include <QtQuick/QQuickView>
#include <QTimer>
#include "sharedspice.h"

#define SAMPLES_PER_FRAME 8000
#define MIN_FRAMES 5
#define MAX_FRAMES 30

class Spice: public QObject {
    Q_OBJECT
	public:
		Spice();
        void start(QString, qreal timestep, qreal frequency, QStringList);
        void restart();
        void pause();
        void resume();
        void setTimestep(qreal timestep);
        void emitSpiceHalted();
        void emitBufferLoaded();
        virtual ~Spice() {}

        QVector<qreal> CH1 = QVector<qreal>(SAMPLES_PER_FRAME * (MAX_FRAMES+1));
        QVector<qreal> CH2 = QVector<qreal>(SAMPLES_PER_FRAME * (MAX_FRAMES+1));
        QVector<qreal> EXT = QVector<qreal>(SAMPLES_PER_FRAME * (MAX_FRAMES+1));

        qreal rmsVoltage2 = 0;
        qreal rmsSum = 0;
        bool voltMeter = false;

        size_t buffer_size; //how many items are there in the buffer
        qreal stop_time; // largest possible time to stop
        qreal end_time; // just before simulation is expected to stop
        bool buffer_ready=false;
        bool running = false;
        bool computing = false;

        QQuickView *appViewer;

	private:
		static int recieve_char(char * str, int id, void * p);
        static int recieve_stat(char* status, int id, void* p);
		static int ngexit(int status, bool unload, bool exit, int id, void* p);
		static int recieve_data(vecvaluesall* data, int numstructs, int id, void* p);
		static int recieve_init_data(vecinfoall* data, int id, void* p);
		static int ngrunning(bool running, int id, void* p);

        void recieveData(vecvaluesall* data);

        qreal timestep;
        qreal frequency;
        qreal nextFrequency;
        QString circuit;

        bool paused = false;
        bool restartOnPause = false; // if new quieries line up while calculating, start the last one when the simulation stops

        QTimer timer;
        QTimer timer2;


        bool seek_phase = false;
        bool firstCycle;
        int CH1A_index;
        int CH1B_index;
        int CH2A_index;
        int CH2B_index;
        int EXTA_index;
        int EXTB_index;
        int VOLTMETERA_index;
        int VOLTMETERB_index;
        int TIME_index;
        qreal start_time;
        qreal last_phase;




        QStringList wanted_measurements;

Q_SIGNALS:

     signals:
        void bufferLoaded();
        void spiceHalted();

    public slots:
        void doRestart();



};

#endif // SPICE_H
