/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef SIGNALGENERATORPROPERTIES_H
#define SIGNALGENERATORPROPERTIES_H

#include <QtCore/QObject>
#include <QQuickView>
#include <random>



QT_BEGIN_NAMESPACE
class QQuickView;
QT_END_NAMESPACE

class DataSource;

class SignalGeneratorProperties : public QObject
{
	Q_OBJECT
	public:
        explicit SignalGeneratorProperties(QQuickView *sgViewer, QObject *parent = 0);
		DataSource * dataSource;
        qreal frequency;
        qreal realFrequency; // randomised
        qreal amplitude;
        qreal dc_offset;
        QString waveform;
        QString toSpice(QString student_number);

    private:
        std::default_random_engine generator;



	Q_SIGNALS:
	public slots:
		void init();
		void update();
        QString formatFrequency(qreal freq);
        void qmlStatusChanged(QQuickView::Status status);

    signals:
        void changed();

	private:
        QQuickView *m_viewer;
        QObject * sgView;
};

#endif // SIGNALGENERATORPROPERTIES_H
