/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef SCOPEPROPERTIES_H
#define SCOPEPROPERTIES_H

#include <QtCore/QObject>
#include <QtCharts/QAbstractAxis>
#include <QPen>
#include "datasource.h"

QT_CHARTS_USE_NAMESPACE


QT_BEGIN_NAMESPACE
class QQuickView;
QT_END_NAMESPACE

class DataSource;

class ScopeProperties : public QObject
{
	Q_OBJECT
	public:
		explicit ScopeProperties(QQuickView *appViewer, QObject *parent = 0);
		QObject * scopeView;
        QObject * trigger;
        QObject * xySwitch;
		QAbstractAxis *axisT1;
		QAbstractAxis *axisY1;
        QAbstractAxis *axisY2;
		qreal secondsPdiv;
        qreal voltsPdiv1;
        qreal voltsPdiv2;
		qreal t_offset;
        qreal V1_offset;
        qreal V2_offset;
		qreal t_scale;
        qreal V1_scale;
        qreal V2_scale;
		DataSource * dataSource;

        QString triggerMode = "OFF";
        QString triggerEdge = "/";
        qreal triggerLevel = 0;

        bool xyMode = false;

        QPen minorGridPen = QPen(Qt::gray, 1, Qt::CustomDashLine, Qt::SquareCap, Qt::RoundJoin);



	Q_SIGNALS:
	public slots:
		void init();
		void update();
        QPen getMinorGridPen(qreal width);

	private:
		QQuickView *m_appViewer;
};

#endif // SCOPEPROPERTIES_H
