/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <QtQuick/QQuickView>
#include <QtCharts/QAbstractSeries>
#include <QtCharts/QXYSeries>
#include <QQmlProperty>


#include "scopeproperties.h"

QT_CHARTS_USE_NAMESPACE


Q_DECLARE_METATYPE(QAbstractSeries *)
Q_DECLARE_METATYPE(QAbstractAxis *)

ScopeProperties::ScopeProperties(QQuickView *appViewer, QObject *parent) :
	QObject(parent),
	m_appViewer(appViewer)
{
	qRegisterMetaType<QAbstractSeries*>();
	qRegisterMetaType<QAbstractAxis*>();
}

void ScopeProperties::init(){
	scopeView = m_appViewer->findChild<QObject*>("scopeView");

    QMetaObject::invokeMethod(scopeView, "axisX", Qt::DirectConnection,
								  Q_RETURN_ARG(QAbstractAxis *, axisT1));

    QMetaObject::invokeMethod(scopeView, "axisY", Qt::DirectConnection,
								  Q_RETURN_ARG(QAbstractAxis *, axisY1));

    axisY2 = (QAbstractAxis *) axisT1->parent()->findChild<QAbstractAxis *>("axisY2");

    trigger = m_appViewer->findChild<QObject*>("trigger");

    xySwitch = m_appViewer->findChild<QObject*>("xySwitch");

	update();
}

void ScopeProperties::update(){

	secondsPdiv = axisT1->property("secondsPdiv").toDouble();
    voltsPdiv1 = axisY1->property("voltsPdiv").toDouble();
    voltsPdiv2 = axisY2->property("voltsPdiv").toDouble();

	t_offset = axisT1->property("offset").toDouble();
    V1_offset = axisY1->property("offset").toDouble();
    V2_offset = axisY2->property("offset").toDouble();

	t_scale = axisT1->property("scaleUnit").toDouble();
    V1_scale = axisY1->property("scaleUnit").toDouble();
    V2_scale = axisY2->property("scaleUnit").toDouble();

    QString tm = trigger->property("mode").toString();
    QString te =  trigger->property("edge").toString();
    qreal tlevel = trigger->property("level").toDouble();

    if(tm != triggerMode || te != triggerEdge || tlevel != triggerLevel){
        triggerMode = tm;
        triggerEdge = te;
        triggerLevel = tlevel;
        dataSource->triggerChanged();
    }

    xyMode = xySwitch->property("checked").toBool();

}

QPen ScopeProperties::getMinorGridPen(qreal width){
    const qreal tickWidth = 0.02;
    minorGridPen.setDashPattern({0,(1-tickWidth)/2*width,tickWidth*width,(1-tickWidth)/2*width});
    return minorGridPen;
};
