/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef MULTIMETERPROPERTIES_H
#define MULTIMETERPROPERTIES_H

#include <QtCore/QObject>
#include <QQuickView>
#include <random>

#include "signalgeneratorproperties.h"



QT_BEGIN_NAMESPACE
class QQuickView;
QT_END_NAMESPACE

class DataSource;

class MultimeterProperties : public QObject
{
	Q_OBJECT
	public:
        explicit MultimeterProperties(QQuickView *mmViewer, QObject *parent = 0);
		DataSource * dataSource;
        SignalGeneratorProperties * signalGeneratorProperties;
        enum modes {OFF, AC_600V, AC_60V, AC_6V, AC_600mV};
        MultimeterProperties::modes mode = OFF;

    private:
        std::default_random_engine generator;



	Q_SIGNALS:
	public slots:
		void init();
		void update();
        void qmlStatusChanged(QQuickView::Status status);
        void setValue(qreal, QString);

    signals:
        void changed();

	private:
        QQuickView *m_viewer;
        QObject * mmView;
        qreal cachedValue = 0;
};

#endif // MULTIMETERPROPERTIES_H
