/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef DATASOURCE_H
#define DATASOURCE_H

#include <QtCore/QObject>
#include <QtCharts/QAbstractSeries>
#include <QtCharts/QChartView>
#include <QtCore/QElapsedTimer>

#include <valarray>
#include <random>

#include "scopeproperties.h"
#include "signalgeneratorproperties.h"
#include "breadboardproperties.h"
#include "multimeterproperties.h"
#include "spice.h"

QT_BEGIN_NAMESPACE
class QQuickView;
QT_END_NAMESPACE

QT_CHARTS_USE_NAMESPACE

class ScopeProperties;

class DataSource : public QObject
{
	Q_OBJECT
public:
    explicit DataSource(QQuickView *appViewer, QQuickView *sgViewer, QQuickView *bbViewer, QObject *parent = 0);
	ScopeProperties * scopeProperties;
    SignalGeneratorProperties * signalGeneratorProperties;
    BreadboardProperties * breadboardProperties;
    MultimeterProperties * multimeterProperties;
    void triggerChanged();

Q_SIGNALS:

public slots:
    void start();
    void stop();
    void resume();
    void update(QtCharts::QAbstractSeries *, QtCharts::QAbstractSeries *, QtCharts::QAbstractSeries *);
    void draw(QtCharts::QAbstractSeries *, QtCharts::QAbstractSeries *, QtCharts::QAbstractSeries *);
	void saveCSV();
    void sgChanged();

private:
	QQuickView *m_appViewer;
    QQuickView *m_sgViewer;
    QQuickView *m_bbViewer;
	std::valarray<qreal> t;
	std::valarray<qreal> V1;
    std::valarray<qreal> V2;
	Spice * spice;

    bool rendering = false;
    bool triggerPossible = true;

    QElapsedTimer real_timer;

    std::default_random_engine generator;
    std::normal_distribution<qreal> gauss_distribution = std::normal_distribution<qreal>(0.,0.0005);
};

#endif // DATASOURCE_H
