/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef BREADBOARDPROPERTIES_H
#define BREADBOARDPROPERTIES_H

#include <QtCore/QObject>
#include <QQuickView>
#include <QJsonObject>



QT_BEGIN_NAMESPACE
class QQuickView;
QT_END_NAMESPACE

class DataSource;

class BreadboardProperties : public QObject
{
	Q_OBJECT
	public:
        explicit BreadboardProperties(QQuickView *bbViewer, QObject *parent = 0);
		DataSource * dataSource;
        QJsonObject info;
        void requestSpice();
        QString getSpiceCode();
        QString student_number = "1";



	Q_SIGNALS:
	public slots:
        void update(QJsonObject info);
        QByteArray loadBbSvg();
        void enable(bool);

    signals:
        void changed();

	private:
        QQuickView *m_viewer;
};

#endif // BREADBOARDPROPERTIES_H
