/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

import QtQuick 2.15
import QtQuick.Layouts 1.11
import QtQuick.Controls 2.15
import QtQuick.Controls.Styles 1.4

Frame {
    id: multimeter
    objectName: "multimeter"

    readonly property variant modes: ["OFF", "AC true RMS 600.0V", "AC true RMS 60.00V", "AC true RMS 6.000V", "AC true RMS 600.0mV"]
    property string mode: "OFF"
    property string value: "0.0"

    function updateProperties(){
        multimeterProperties.update();
    }

    FontLoader { id: lcdFont; source: "qrc:/font/Segment7Standard.otf" }

    ColumnLayout {
        Text {
            id: lcd
            text: multimeter.value
            horizontalAlignment: Text.AlignRight
            Layout.fillWidth: true
            font.family: lcdFont.name
            font.pointSize: 20
            enabled: multimeter.mode !== "OFF"
        }

        RowLayout {
            Text{
                text: "Mode"
            }

            ComboBox {
                id: muiltimeterModeCombo
                model: multimeter.modes
                currentIndex: 0
                Layout.fillWidth: true
                Layout.minimumWidth: 450
                onCurrentIndexChanged: {
                    multimeter.mode = multimeter.modes[currentIndex];
                    multimeter.updateProperties();
                }

            }
        }




    }
}
