/*
Breaboard simulator
Copyright (C) 2020  Balázs Dura-Kovács

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

import QtQuick 2.15
import QtQuick.Controls 2.15
import QtWebEngine 1.10
import QtWebChannel 1.15
import QtQuick.Layouts 1.11

Frame {

    QtObject {
        id: communicator
        objectName: "communicator"
        // ID, under which this object will be known at WebEngineView side
        WebChannel.id: "backend"

        property bool webenabled: true


        signal getSpice();

        function requestSpice(){
            communicator.getSpice();
        }

        signal toggleEnabled();

        function loadBbSvg(){
            return breadboardProperties.loadBbSvg();
        }

        function gotSpice(info){
            breadboardProperties.update(info);
        }
    }

    height: 750
    width: 1024


    WebEngineView {
        id: web
        objectName: "web"
        anchors.fill: parent
        url: "qrc:/breadboard/app.html"
        webChannel: channel
        enabled: true
        zoomFactor: 1.0
        Layout.minimumHeight: 750
        Layout.minimumWidth: 930
    }

    WebChannel {
      id: channel
      registeredObjects: [communicator]
    }
}
