import QtQuick 2.15
import QtCharts 2.3
import QtQuick.Layouts 1.11
import QtQuick.Controls 2.15

Frame {
    visible: true

    Component.onCompleted: scopeRow.update()

    RowLayout {

        id: scopeRow

        function update(){
            datasource.update(sliderR.value, sliderL.value, sliderC.value,
                              resonanceSeries, resonanceLine, phaseSeries, resonanceLine2);
        }

        ChartView {
             id: resonanceChartView
             width: 400
             height: 400


             animationOptions: ChartView.NoAnimation
             theme: ChartView.ChartThemeBlueNcs
             antialiasing: true
             legend.visible: false

             ValueAxis {
                 property double w_max: 220000.0

                 id: axisX1
                 gridVisible: false
                 minorGridVisible: false
                 min: 0
                 max: w_max
                 titleText: "ω (a.u.)"
                 tickType: ValueAxis.TicksDynamic
                 tickAnchor: 0
                 tickInterval: w_max * 2
                 labelFormat: "%1.0f"
             }

             ValueAxis {
                 id: axisY1
                 min: 0
                 max: 6.5
                 titleText: "V<sub>C0</sub> (a.u.)"
                 minorGridVisible: false
                 gridVisible: false
                 tickType: ValueAxis.TicksDynamic
                 tickAnchor: 0
                 tickInterval: 20
                 labelFormat: "%1.0f"
             }

             LineSeries {
                 id: resonanceSeries
                 objectName: "resonanceSeries"
                 axisX: axisX1
                 axisY: axisY1
                 useOpenGL: true
                 width: 3
                 color: "#9E0000"
             }

             LineSeries {
                 id: resonanceLine
                 axisX: axisX1
                 axisY: axisY1
                 useOpenGL: true // todo: disable for non-wasm
                 width: 3
                 color: "#ababab"
                 style: "DashLine"
             }
         }

        ChartView {
             id: phaseChartView
             width: 400
             height: 400


             animationOptions: ChartView.NoAnimation
             theme: ChartView.ChartThemeBlueNcs
             antialiasing: true
             legend.visible: false

             ValueAxis {
                 property double w_max: 220000.0

                 id: axisX2
                 gridVisible: false
                 minorGridVisible: false
                 min: 0
                 max: w_max
                 titleText: "ω (a.u.)"
                 tickType: ValueAxis.TicksDynamic
                 tickAnchor: 0
                 tickInterval: w_max * 2
                 labelFormat: "%1.0f"
             }

             CategoryAxis {
                 id: axisY2
                 min: 0
                 max: Math.PI
                 titleText: "Phase |φ|"
                 minorGridVisible: false
                 gridVisible: true
                 tickType: ValueAxis.TicksDynamic
                 tickAnchor: Math.PI/2
                 tickInterval: Math.PI/2
                 labelsPosition: CategoryAxis.AxisLabelsPositionOnValue
                 CategoryRange {
                     label: "0"
                     endValue: 0
                 }
                 CategoryRange {
                     label: "π/2"
                     endValue: Math.PI/2
                 }
                 CategoryRange {
                     label: "π"
                     endValue: Math.PI
                 }
             }

             LineSeries {
                 id: phaseSeries
                 objectName: "phaseSeries"
                 axisX: axisX2
                 axisY: axisY2
                 useOpenGL: true
                 width: 3
                 color: "#000000"
             }

             LineSeries {
                 id: resonanceLine2
                 axisX: axisX2
                 axisY: axisY2
                 useOpenGL: true // todo: disable for non-wasm
                 width: 3
                 color: "#ababab"
                 style: "DashLine"
             }
         }

        ColumnLayout {
            id: sliderColumn
            x: 400
            y: 111

            spacing: 6

            Layout.fillHeight: true

            Text {
                text: qsTr("R")
                Layout.fillWidth: true
                horizontalAlignment: Text.AlignHCenter
            }

            Slider {
                id: sliderR
                Layout.fillWidth: true
                stepSize: 0.01
                from: -1.0
                to: 1.0
                value: 0.0
                onValueChanged: scopeRow.update()
            }

            Text {
                text: qsTr("L")
                Layout.fillWidth: true
                horizontalAlignment: Text.AlignHCenter
            }

            Slider {
                id: sliderL
                Layout.fillWidth: true
                stepSize: 0.01
                from: -1.0
                to: 1.0
                value: 0.0
                onValueChanged: scopeRow.update()
            }

            Text {
                text: qsTr("C")
                Layout.fillWidth: true
                horizontalAlignment: Text.AlignHCenter
            }

            Slider {
                id: sliderC
                Layout.fillWidth: true
                stepSize: 0.01
                from: -1.0
                to: 1.0
                value: 0.0
                onValueChanged: scopeRow.update()
            }
       }


    }





}


