#include <QtWidgets/QApplication>
#include <QtQml/QQmlContext>
#include <QtQuick/QQuickView>
#include <QtQml/QQmlEngine>
#include <QtQml/QQmlApplicationEngine>
#include <QtCore/QDir>

#include "datasource.h"

int main(int argc, char *argv[])
{

	//QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

	// Qt Charts uses Qt Graphics View Framework for drawing, therefore QApplication must be used.
	QApplication app(argc, argv);

	QQuickView viewer;

	QObject::connect(viewer.engine(), &QQmlEngine::quit, &viewer, &QWindow::close);

	viewer.setTitle(QStringLiteral("Pre-lab demo"));

	DataSource dataSource(&viewer);
	viewer.rootContext()->setContextProperty("datasource", &dataSource);

	viewer.setSource(QUrl("qrc:/main.qml"));
	viewer.setResizeMode(QQuickView::SizeRootObjectToView);
	viewer.setColor(QColor("#efefef"));
	viewer.show();

	return app.exec();
}
