/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Charts module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "datasource.h"
#include <QtCharts/QXYSeries>
#include <QtCharts/QAreaSeries>
#include <QtQuick/QQuickView>
#include <QtQuick/QQuickItem>

#include <valarray>

// amplitude in function of frequency
#define V0C_(w) ( E0 / (C * sqrt( pow((w)*R,2) + pow(L * ((w)*(w) - w0*w0) ,2) ) ) )

#define w_max 220000.0 // max freq in 1/s

QT_CHARTS_USE_NAMESPACE

Q_DECLARE_METATYPE(QAbstractSeries *)
Q_DECLARE_METATYPE(QAbstractAxis *)

DataSource::DataSource(QQuickView *appViewer, QObject *parent) :
	QObject(parent),
	m_appViewer(appViewer),
	m_index(-1)
{
	qRegisterMetaType<QAbstractSeries*>();
	qRegisterMetaType<QAbstractAxis*>();

}

/*void DataSource::update(QAbstractSeries *series)
{
	if (series) {
		QXYSeries *xySeries = static_cast<QXYSeries *>(series);
		m_index++;
		if (m_index > m_data.count() - 1)
			m_index = 0;

		QVector<QPointF> points = m_data.at(m_index);
		// Use replace instead of clear + append, it's optimized for performance
		xySeries->replace(points);
	}
}*/

void DataSource::update(qreal Rs, qreal Ls, qreal Cs,
						QAbstractSeries *resonanceSeries, QAbstractSeries *resonanceLine,
						QAbstractSeries *phaseSeries, QAbstractSeries *resonanceLine2){

	const int size = 400; // number of datapoints on plot

	const qreal Rcentral = 1000; // 1.5kΩ
	const qreal Lcentral = 36. / 1000.; // 36mH
	const qreal Ccentral = 2700. * 1E-12F; // 2700 pF

	// Allow range */ 1.5 of values
	qreal R = Rcentral * pow(1.5, Rs);
	qreal L = Lcentral * pow(1.5, Ls);
	qreal C = Ccentral * pow(1.5, Cs);

	qreal w0 = 1 / sqrt(L * C);
	qreal wres = sqrt(w0*w0 - R*R / (2 * L*L));
	qreal E0 = 1;

	// generate frequency values
	std::valarray<qreal> w(size);
	for(size_t i=0; i<size; i++){
		w[i] = w_max * qreal(i) / size;
	}

	std::valarray<qreal> Vc0 = V0C_(w);

	std::valarray<qreal> phi = atan(R / (w*L - 1/(w*C)) );
	for(size_t i=0; i<size; i++){
		if(phi[i] > 0){
			phi[i] = M_PI - phi[i];
		}else{
			phi[i] = -phi[i];
		}
	}



	QVector<QPointF> resonancePoints(size);
	QVector<QPointF> phasePoints(size);


	for(size_t i=0; i<size; i++){
		resonancePoints[i] = {w[i], Vc0[i]};
		phasePoints[i] = {w[i], phi[i]};
	}

	QXYSeries *xyResonanceSeries = static_cast<QXYSeries *>(resonanceSeries);
	xyResonanceSeries->replace(resonancePoints);

	QXYSeries *xyResonanceLine = static_cast<QXYSeries *>(resonanceLine);
	xyResonanceLine->replace(QVector<QPointF> {{wres,0},{wres,V0C_(wres)}});

	QXYSeries *xyPhaseSeries = static_cast<QXYSeries *>(phaseSeries);
	xyPhaseSeries->replace(phasePoints);

	QXYSeries *xyResonanceLine2 = static_cast<QXYSeries *>(resonanceLine2);
	xyResonanceLine2->replace(QVector<QPointF> {{wres,0},{wres,M_PI}});
}
