function [g] = vgrating(w, h, wavelength, ph)
%VGRATING creates a vertical sine grating in range [0,1]
% GRATING = VGRATING ( WIDTH, HEIGHT, WAVELENGTH, PHASE_OFFSET )

if nargin < 1, w = 100; end
if nargin < 2, h = w; end
if nargin < 3, wavelength = 10; end
if nargin < 4, ph = 0; end

step = 2 * pi / wavelength;
for x = 1 : w
    r(x) = (1 + sin(ph + (x - 1) * step))/2;
end
g = [];
for x = 1 : h
    g = [g;r];
end