function t = target()
%TARGET creates a b+w test image
% T = TARGET ()

c1 = checkerboard(8, 4, 4) > 0.5;
c2 = checkerboard(4, 8, 8) > 0.5;
c3 = checkerboard(2, 16, 16) > 0.5;
c4 = checkerboard(1, 32, 32) > 0.5;

c = [ c1, c3; c4, c2 ];

s1 = stripes(1, 64, 32);
s2 = stripes(2, 32, 32);
s3 = stripes(3, 22, 32); s3 = s3(1:128, :);
s4 = stripes(4, 16, 32);

s = [ s1, s2, s3, s4 ];

y1 = cycrep();
y2 = cycrep([0 0 0 1 1 1]);
y3 = cycrep([0 0 0 0 1 1 1 1]);
y4 = cycrep([0 0 0 0 0 0 1 1]);

z1a = repmat(y1, 8, 16);
z1b = fliplr(z1a);

z2a = repmat(y2, 6, 11); z2a = z2a(1:32, 1:64);
z2b = fliplr(z2a);

z3a = repmat(y3, 4, 8);
z3b = fliplr(z3a);

z4a = repmat(y4, 4, 8);
z4b = fliplr(z4a);

z = [ [z3b; z3a], [z2a; z2b]; [z1b; z1a], [z4a; z4b] ];

t = [ z, s; s.', c ];