function s = stripes(thickness, repeats, width, col1, col2)
%STRIPES creates 2-colour horizontal stripes
% S = STRIPES (THICKNESS, REPEATS, WIDTH, COLOR1, COLOR2)
%
% THICKNESS may be either an integer or a vector. If the former,
% the two stripe colours are the same thickness. If the latter,
% the first element is the thickness of the first colour, the
% second is the thickness of the second. Default colours are 0
% (black) and 1 (white).

if nargin < 1, thickness = 2; end
if nargin < 2, repeats = 32; end
if nargin < 3, width = 128; end
if nargin < 4, col1 = 0; end
if nargin < 5, col2 = 1; end

[h w] = size(thickness);
if w > 1
    t1 = thickness(1);
    t2 = thickness(2);
else
    t1 = thickness;
    t2 = thickness;
end

s = repmat( [ repmat(col1, t1, width); repmat(col2, t2, width)], repeats, 1 );