function [f1 f2 f3 c0 c1] = sinsim4 ( obj, noise, period, cut1, cut2 )
%SINSIM4 simulates patterned excitation with a sin grating and minmax reconstruction
% [F1 F2 F3 C0 C1] = SINSIM4 ( OBJ, NOISE, PERIOD, FRAC1, FRAC2 )
%

if nargin < 1, obj = target(); end
if nargin < 2, noise = 0.1; end
if nargin < 3, period = 5; end

[h w] = size(obj);

if nargin < 4, cut1 = 0.5; end
if nargin < 5, cut2 = cut1; end

if length(noise) > 1
    varnoise = noise(2);
    noise = noise(1);
else
    varnoise = 0;
end

[ch1 ch2 ch3] = phases(w, h, period);

f1 = obj .* otfblur(ch1, cut1);
f2 = obj .* otfblur(ch2, cut1);
f3 = obj .* otfblur(ch3, cut1);

n = blur(rand(h,w) * noise, 20);

f1 = otfblur(n + f1, cut2);
f2 = otfblur(n + f2, cut2);
f3 = otfblur(n + f3, cut2);

if varnoise > 0
    f1 = imnoise(f1, 'gaussian', 0, varnoise);
    f2 = imnoise(f2, 'gaussian', 0, varnoise);
    f3 = imnoise(f3, 'gaussian', 0, varnoise);
end

c0 = otfblur(n + obj, cut2); c = imnoise(f1, 'gaussian', 0, varnoise); c0 = c0/max(max(c0));

c1 = excess(f1, f2, f3);