function [c0 c1 c2 vv hh] = sincombo ( obj, noise, period, cut1, cut2 )
%SINCOMBO simulates perpendicular excitations with a sin grating
% [C0 C1 C2 VV HH] = SINCOMBO ( OBJ, NOISE, PERIOD, FRAC1, FRAC2 )
%

if nargin < 1, obj = target(); end
if nargin < 2, noise = 1; end
if nargin < 3, period = 6; end
if nargin < 4, cut1 = 0.5; end
if nargin < 5, cut2 = cut1; end


[f1 f2 f3 c0 hh] = sinsim3( obj, noise, period, cut1, cut2);

% transpose for perpendicular version, then transpose back
[f1 f2 f3 x0 vv] = sinsim3( obj.', noise, period, cut1, cut2);
vv = vv.';

c1 = normalise(max(vv, hh));
c2 = normalise(vv + hh);
