function varargout = phases(w, h, wavelength)
%PHASES produces evenly-spaced phase-shifted vertical gratings
% [G1 G2 ... ] = PHASES ( W, H, WAVELENGTH )

if nargin < 1, w = 100; end
if nargin < 2, h = w; end
if nargin < 3, wavelength = 10; end

for i = 1 : nargout
    varargout(i) = {vgrating(w, h, wavelength, (i-1) * 2 * pi / nargout)};
end
