function [img2, ft] = otfblur(img1, cut)
%OTFBLUR performs an idealised OTF blur
% [IMG2, FT] = OTFBLUR ( IMG1, PROPORTION )

if nargin < 1, img1 = target(); end
[h w] = size(img1);
if nargin < 2, cut = 0.5; end

% pad to doubled square
pad = 2 * max([h w]);
t = fft2(img1, pad, pad);

% diameter of OTF (doubled because of padding)
d = floor(max([h w]) * cut * 2);
otf = circotf(d);

% centre in black field
f = zeros(max([pad d]));
off = floor((pad-d)/2);
if off < 1, off = 1; end

f( off:(off+d-1), off:(off+d-1) ) = otf;
[h1 w1] = size(f);
clip = floor((h1 - pad)/2);

if (clip > 0), f = f( clip:(clip+pad-1), clip:(clip+pad-1) ); end

ft = fftshift(f) .* t;

% invert transform and remove padding
img2 = real(ifft2(ft));
img2 = img2(1:h, 1:w);
