function img = excess(i1, varargin)
%EXCESS returns the max pixel less the min at each position
% IMG = EXCESS ( IM1, IM2, ... IN )
%
% Either pass the images as separate args, or else as a single-row cell
% array

if nargin == 1
    mx = i1{1,1};
    mn = mx;
    
    [h w] = size(i1);
    
    for ix = 2:w
        mx = max(mx, i1{1, ix});
        mn = min(mn, i1{1, ix});
    end
else
    mx = i1;
    mn = i1;

    for ix = 1:(nargin-1)
        mx = max(mx, varargin{ix});
        mn = min(mn, varargin{ix});
    end
end

img = mx - mn;
