function m = cycrep(vec, duprows)
%CYCREP maps a vector to a matrix containing one full cycle of left shifts
% M = CYCREP (VEC, DUPLICATE_ROWS)

if nargin < 1, vec = [0 0 1 1]; end
if nargin < 2, duprows = 1; end

[r c] = size(vec);
m = repmat(vec, duprows, 1);
for x = 2:c
    z = [vec(x:c), vec(1:(x-1))];
    for y = 1:duprows
        m = [m;z];
    end
end
