function [c0 c1 ff] = chksimnx ( obj, noise, tile, sub, cut1, cut2 )
%CHKSIMNX simulates supersampled excitation with a checkerboard pattern
% [C0 C1 C2 FF] = SQSIMNX( OBJ, NOISE, TILE, SAMP, FRAC1, FRAC2 )
%
% TILE is the size of single square in pixels
% SAMP is the number samples per cycle in one direction (ie, SAMP^2 samples
%      will be taken overall)
% 
% return values are *not* normalised

% default args
if nargin < 1, obj = target(); end
if nargin < 2, noise = 1; end
if nargin < 3, tile = 3; end
if nargin < 4, sub = 3; end
if nargin < 5, cut1 = 0.5; end
if nargin < 6, cut2 = cut1; end

[h w] = size(obj);

% check pattern big enough to subset for all samples
chk = checkerboard(tile, 1 + ceil(h/(tile * 2)), 1 + ceil(w/(tile * 2))) > 0.5;

% generate phased illumination patterns with OTF (ie, at object)
ff = cell(1, sub * sub);
step = 2*tile/sub;
for x = 1:sub
    xoff = floor((x-1)*step);
    for y = 1:sub
        yoff = floor((y-1)*step);
        ch1 = chk( (1+yoff):(h+yoff), (1+xoff):(w+xoff) );
        ff{1, (x-1) * sub + y} = obj .* otfblur(ch1, cut1);
    end
end

% add constant noise of given intensity and apply second OTF to get image
n = blur(rand(h,w) * noise, 20);
for x = 1:(sub*sub)
    ff{1, x} = otfblur(ff{1, x} + (n/2), cut2);
end

% c0 is uniformly-illuminated version
c0 = otfblur(n + obj, cut2);

% c1 is image reconstructed from frames
c1 = excess(ff);
